IF OBJECT_ID('V_EST_PROD_CPL_DROGASMIL') IS NOT NULL
BEGIN
	DROP VIEW V_EST_PROD_CPL_DROGASMIL
END
GO

CREATE VIEW
	V_EST_PROD_CPL_DROGASMIL
AS
SELECT 
	CPL.CD_FILIAL, 
	ISNULL(VPU.CD_PROD_BANDEIRA,CPL.CD_PROD) AS CD_PROD, 
	PROD.DS_USUAL, 
	CASE WHEN PREC.VLR_OFERTA > 0 THEN PREC.VLR_OFERTA ELSE PREC.VLR_TABELA 
	END AS VLR_PROD 
FROM EST_PROD_CPL CPL
	INNER JOIN EST_PROD PROD ON 
	CPL.CD_EMP = PROD.CD_EMP 
	AND CPL.CD_PROD = PROD.CD_PROD
	INNER JOIN EST_PROD_PRECO PREC ON 
	PREC.CD_EMP = CPL.CD_EMP 
	AND PREC.CD_PROD = CPL.CD_PROD 
	AND PREC.CD_FILIAL = CPL.CD_FILIAL
	LEFT JOIN V_CAD_UNICO_DEPARAS_EST_PROD VPU ON
	VPU.CD_FILIAL=CPL.CD_FILIAL AND
	VPU.CD_PROD= CPL.CD_PROD

WHERE PROD.STS_PROD = 0 
	AND CONVERT(DATE,PROD.DT_ULT_ATU) = CONVERT(DATE,GETDATE())


